; transpose4x4.asm
extern printf

section .data
	fmt0	db	10,"TRANSPOZYCJA ZMIENNOPRZECINKOWEJ MACIERZY 4x4 PODWÓJNEJ PRECYZJI",10,0
	fmt1	db	10,"Oto macierz:",10,0
	fmt2	db	10,"Oto transpozycja (odpakowanie):",10,0
	fmt3	db	10,"Oto transpozycja (tasowanie):",10,0

	align 	32							
	matrix	dq       1.,     2.,     3.,     4.      
              	dq       5.,     6.,     7.,     8.        
             	dq       9.,    10.,    11.,    12.  
            	dq      13.,    14.,    15.,    16.  
section .bss
	alignb 	32
	transpose	resd	16

section .text							
	global main					
main:
push	rbp
mov	rbp,rsp

; wypisujemy tytuł
	mov	rdi, fmt0
	call	printf

; wypisujemy macierz
	mov	rdi,fmt1
	call printf
	mov	rsi,matrix
	call	printm4x4
               
; obliczamy transpozycję z odpakowaniem
	mov	rdi, matrix        
	mov	rsi, transpose 
	call	transpose_unpack_4x4

; wypisujemy wynik
	mov	rdi, fmt2
	xor	rax,rax
	call	printf
	mov	rsi, transpose
	call	printm4x4 

; obliczamy transpozycję z tasowaniem 
	mov	rdi, matrix        
	mov	rsi, transpose 
	call	transpose_shuffle_4x4

; wypisujemy wynik
	mov	rdi, fmt3
	xor	rax,rax
	call	printf
	mov	rsi, transpose
	call	printm4x4 
leave
ret
;--------------------------------------------------------
transpose_unpack_4x4:
push	rbp
mov	rbp,rsp    
; wczytujemy macierz do rejestrów
	vmovapd 	ymm0,[rdi]	;  1   2   3   4
    	vmovapd 	ymm1,[rdi+32]	;  5   6   7   8     
    	vmovapd 	ymm2,[rdi+64]	;  9  10  11  12
    	vmovapd 	ymm3,[rdi+96]	; 13  14  15  16
; odpakowujemy
    	vunpcklpd	ymm12,ymm0,ymm1	;  1   5   3   7
    	vunpckhpd ymm13,ymm0,ymm1	;  2   6   4   8
    	vunpcklpd ymm14,ymm2,ymm3	;  9  13  11  15
    	vunpckhpd ymm15,ymm2,ymm3    	; 10  14  12  16
; permutujemy 
    	vperm2f128 ymm0,ymm12,ymm14,	00100000b    ; 1   5   9  13
    	vperm2f128 ymm1,ymm13,ymm15, 	00100000b    ; 2   6  10  14
    	vperm2f128 ymm2,ymm12,ymm14,  00110001b    ; 3   7  11  15 
    	vperm2f128 ymm3,ymm13,ymm15, 	00110001b    ; 4   8  12  16
; zapisujemy w pamięci
    	vmovapd 	[rsi],   ymm0
    	vmovapd 	[rsi+32],ymm1      
    	vmovapd 	[rsi+64],ymm2
    	vmovapd 	[rsi+96],ymm3
leave
ret
;--------------------------------------------------------    
transpose_shuffle_4x4:
push	rbp
mov	rbp,rsp
; wczytujemy macierz do rejestrów
	vmovapd 	ymm0,[rdi]	;  1   2   3   4
	vmovapd 	ymm1,[rdi+32]	;  5   6   7   8     
    	vmovapd 	ymm2,[rdi+64]	;  9  10  11  12
    	vmovapd 	ymm3,[rdi+96]	; 13  14  15  16
; tasujemy
    	vshufpd 	ymm12,ymm0,ymm1, 0000b	;  1   5   3   7 
    	vshufpd 	ymm13,ymm0,ymm1, 1111b	;  2   6   4   8
    	vshufpd 	ymm14,ymm2,ymm3, 0000b	;  9  13  11  15    
    	vshufpd 	ymm15,ymm2,ymm3, 1111b	; 10  14  12  16 
; permutujemy
    	vperm2f128 ymm0,ymm12,ymm14,	00100000b    ; 1   5   9  13
    	vperm2f128 ymm1,ymm13,ymm15, 	00100000b    ; 2   6  10  14
    	vperm2f128 ymm2,ymm12,ymm14,  00110001b    ; 3   7  11  15 
    	vperm2f128 ymm3,ymm13,ymm15, 	00110001b    ; 4   8  12  16
; zapisujemy w pamięci
    	vmovapd 	[rsi],   ymm0
    	vmovapd 	[rsi+32],ymm1      
    	vmovapd 	[rsi+64],ymm2
    	vmovapd 	[rsi+96],ymm3
leave
ret
;--------------------------------------------------------
printm4x4:
section .data
	.fmt 	db	"%.f",9,"%.f",9, "%.f",9,"%.f",10,0
section .text
push	rbp
mov	rbp,rsp
push	rbx	       	; zapisywany przez wywołanego
push	r15            ; zapisywany przez wywołanego
	mov 	rdi,.fmt
	mov 	rcx,4
	xor 	rbx,rbx	; licznik wierszy
.loop:        
	movsd 	xmm0, [rsi+rbx]
	movsd 	xmm1, [rsi+rbx+8]
	movsd 	xmm2, [rsi+rbx+16]
	movsd 	xmm3, [rsi+rbx+24]
	mov    	rax,4	;four floats
        push 	rcx		; zapisywany przez wywołującego
        push 	rsi		; zapisywany przez wywołującego
        push 	rdi		; zapisywany przez wywołującego
        ; w razie potrzeby wyrównujemy stos
        xor 	r15,r15
        test 	rsp,0fh	; ostatni bajt równy 8 (stos niewyrównany)? 
        setnz 	r15b     	; ustawiamy, jeśli niewyrównany
        shl 	r15,3    	; mnożymy przez 8
        sub 	rsp,r15  	; odejmujemy 0 lub 8
	call 	printf
        add 	rsp,r15	;dodajemy 0 lub 8
        pop 	rdi
        pop 	rsi
        pop 	rcx
        add 	rbx,32	; następny wiersz
        loop 	.loop
pop r15
pop rbx
leave
ret
